package com.valor.vod.meta.model.database.ddo.identifier;

import com.valor.vod.common.database.model.AbstractLMI;

import javax.persistence.*;

/**
 * Created by Frank.Huang on 2016/4/30.
 */
@Entity
@Table(name = "id_generator")
public class Identifier extends AbstractLMI {
    @Id
    @Column(name = "type")
    protected int type;

    @Column(name = "latest")
    protected long latest;

    @Transient
    protected long current;

    @Transient
    protected long origin;

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public long getLatest() {
        return latest;
    }

    public void setLatest(long latest) {
        this.latest = latest;
    }

    public long getCurrent() {
        return current;
    }

    public void setCurrent(long current) {
        this.current = current;
    }

    public void batchIncrease(int size) {
        latest = latest + size;
    }

    public boolean increase() {
        if (current >= latest) {
            return false;
        }
        current++;
        return true;
    }

    public long getOrigin() {
        return origin;
    }

    public void setOrigin(long origin) {
        this.origin = origin;
    }
}
