package com.valor.vod.meta.model.database.ddo.media;

import com.google.common.base.Objects;
import com.valor.vod.api.model.constant.EVideoType;
import com.valor.vod.common.database.model.AbstractLMI;
import com.valor.vod.meta.model.database.ddo.media.base.AbstractId;
import com.valor.vod.meta.model.database.ddo.media.emum.EMetaEventType;
import common.base.tools.type.DdoKeyTools;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;

/**
 * @ClassName: MetaEventLog
 * @Auther: vv
 * @Date: 6/24/2019
 * @Version 1.0
 * @Description:
 */

@Entity
@Table(name = "vms_meta_event_log")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class MetaEventLog extends AbstractLMI {

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.AUTO)
    public Long id;

    @Column(name = "account_id")
    private long accountId;
    @Column(name = "account_type")
    private int accountType;

    @Enumerated(EnumType.ORDINAL)
    @Column(name = "event_type")
    private EMetaEventType metaEventType;

    @Column(name = "vms_id")
    private long vmsId;
    @Column(name = "episode_id")
    private long episodeId = 0;
    @Column(name = "meta_id", length = 16)
    private String metaId = "";

    @Column(name = "season_id", length = 16)
    private long seasonId = 0;

    @Enumerated(EnumType.ORDINAL)
    @Column(name = "video_type")
    private EVideoType videoType;

    @Column(name = "did")
    private String did;

    @Column(name = "client_ip")
    private String clientIp;


    public Long getId() {
        return this.getId();
    }

    public void setId(Long id) {
        this.id = id;
    }

    public EVideoType getVideoType() {
        return videoType;
    }

    public void setVideoType(EVideoType videoType) {
        this.videoType = videoType;
    }

    public long getAccountId() {
        return accountId;
    }

    public void setAccountId(long accountId) {
        this.accountId = accountId;
    }

    public int getAccountType() {
        return accountType;
    }

    public void setAccountType(int accountType) {
        this.accountType = accountType;
    }

    public EMetaEventType getMetaEventType() {
        return metaEventType;
    }

    public void setMetaEventType(EMetaEventType metaEventType) {
        this.metaEventType = metaEventType;
    }

    public String getDid() {
        return did;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getMetaId() {
        return metaId;
    }

    public void setMetaId(String metaId) {
        this.metaId = metaId;
    }

    public long getVmsId() {
        return vmsId;
    }

    public void setVmsId(int vmsId) {
        this.vmsId = vmsId;
    }

    public void setVmsId(long vmsId) {
        this.vmsId = vmsId;
    }

    public long getEpisodeId() {
        return episodeId;
    }

    public void setEpisodeId(int episodeId) {
        this.episodeId = episodeId;
    }

    public void setEpisodeId(long episodeId) {
        this.episodeId = episodeId;
    }

    public long getSeasonId() {
        return seasonId;
    }

    public void setSeasonId(long seasonId) {
        this.seasonId = seasonId;
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(id);
    }

    @Override
    public boolean valueEquals(Object o) {
        return equals(0);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractId that = (AbstractId) o;

        return Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(id);
    }

}
