package com.valor.vod.meta.model.database.ddo.media;

import com.google.common.base.Objects;
import com.valor.vod.api.model.constant.EVideoType;
import com.valor.vod.common.database.model.AbstractLMI;
import com.valor.vod.meta.model.database.ddo.media.base.AbstractId;
import com.valor.vod.meta.model.database.ddo.media.emum.EMetaMetricType;
import common.base.tools.type.DdoKeyTools;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;

/**
 * @ClassName: MetaMetricTask
 * @Auther: vv
 * @Date: 6/24/2019
 * @Version 1.0
 * @Description:
 */

@Deprecated
//@Entity
@Table(name = "vms_meta_metric_task",
    indexes = {@Index(name = "index_last_modify_time", columnList = "last_modify_time")
    })
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class MetaMetricTask extends AbstractLMI {

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.AUTO)
    public Long id;

    @Column(name = "meta_id", length = 16)
    private String metaId = "";

    @Enumerated(EnumType.ORDINAL)
    @Column(name = "metric_type")
    private EMetaMetricType metaMetricType;

    @Column(name = "vms_id")
    private long vmsId;

    @Enumerated(EnumType.ORDINAL)
    @Column(name = "video_type")
    private EVideoType videoType;


    @Column(name = "is_task_done", columnDefinition = "int default 0")
    private int isTaskDone;


    public long getVmsId() {
        return vmsId;
    }

    public void setVmsId(long vmsId) {
        this.vmsId = vmsId;
    }


    public int getIsTaskDone() {
        return isTaskDone;
    }

    public void setIsTaskDone(int isTaskDone) {
        this.isTaskDone = isTaskDone;
    }


    public String getMetaId() {
        return metaId;
    }

    public void setMetaId(String metaId) {
        this.metaId = metaId;
    }

    public EVideoType getVideoType() {
        return videoType;
    }

    public void setVideoType(EVideoType videoType) {
        this.videoType = videoType;
    }

    public EMetaMetricType getMetaMetricType() {
        return metaMetricType;
    }

    public void setMetaMetricType(EMetaMetricType metaMetricType) {
        this.metaMetricType = metaMetricType;
    }


    public Long getId() {
        return this.getId();
    }


    public void setId(Long id) {
        this.setId(id);
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(id);
    }

    @Override
    public boolean valueEquals(Object o) {
        return equals(0);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractId that = (AbstractId) o;

        return Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(id);
    }
}
