package com.valor.vod.meta.model.database.ddo.media.base;

import com.google.common.base.Objects;
import com.valor.vod.common.database.model.AbstractLMI;
import com.valor.vod.common.tools.type.DdoKeyTools;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/4/29.
 */
@MappedSuperclass
public abstract class AbstractCompany extends AbstractLMI {
    @Id
    @Column(name = "media_id")
    public long mediaId;

    @Id
    @Column(name = "company_id", columnDefinition = "varchar(31) default 0 COMMENT 'companyId'")
    public String companyId;

    @Id
    @Column(name = "attribute", columnDefinition = "varchar(127) default 0 COMMENT 'name'")
    private String attribute;
    @Id
    @Column(name = "type", columnDefinition = "int(11) default 0 COMMENT 'type'")
    private int type;
    @Column(name = "pos", columnDefinition = "int(11) default 0 COMMENT 'pos'")
    private int pos;

    public boolean isValid() {
        if (mediaId < 1) {
            return false;
        }

        if (StringUtils.isEmpty(companyId)) {
            return false;
        }

        return true;
    }

    public long getMediaId() {
        return mediaId;
    }

    public void setMediaId(long mediaId) {
        this.mediaId = mediaId;
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getAttribute() {
        return attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getPos() {
        return pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractCompany that = (AbstractCompany) o;

        return Objects.equal(this.mediaId, that.mediaId) &&
            Objects.equal(this.companyId, that.companyId) &&
            Objects.equal(this.type, that.type);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(mediaId, companyId, type);
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(mediaId, companyId, type);
    }

    @Override
    public boolean valueEquals(Object o) {
        if (!equals(o)) {
            return false;
        } else {
            AbstractCompany that = (AbstractCompany) o;

            return Objects.equal(this.type, that.type)
                && Objects.equal(this.pos, that.pos);
        }
    }
}
