package com.valor.vod.meta.model.database.ddo.media.base;

import com.google.common.base.Objects;
import com.valor.vod.common.tools.type.DdoKeyTools;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/4/29.
 */
@MappedSuperclass
public abstract class AbstractCriticReview extends AbstractLocaleId {
    @Id
    @Column(name = "review_key", length = 128)
    public String reviewKey;

    @Column(name = "attr", length = 256)
    private String attr;

    @Column(name = "label", length = 256)
    private String label;

    @Column(name = "url", length = 1024)
    private String url;


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractCriticReview that = (AbstractCriticReview) o;

        return Objects.equal(this.reviewKey, that.reviewKey) &&
            Objects.equal(this.language, that.language) &&
            Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(reviewKey, language, id);
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(id, language, reviewKey);
    }

    @Override
    public boolean valueEquals(Object o) {
        if (!equals(o)) {
            return false;
        } else {
            AbstractCriticReview that = (AbstractCriticReview) o;

            return Objects.equal(this.attr, that.attr)
                && Objects.equal(this.label, that.attr)
                && Objects.equal(this.url, that.url);
        }
    }
}
