package com.valor.vod.meta.model.database.ddo.media.base;

import com.google.common.base.Objects;
import com.valor.vod.common.database.model.AbstractLMI;
import com.valor.vod.common.tools.type.DdoKeyTools;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/** Created by Frank.Huang on 2016/4/28. */
@MappedSuperclass
public abstract class AbstractId extends AbstractLMI {
    @Id
    @Column(name = "id")
    public Long id = -1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(id);
    }

    @Override
    public boolean valueEquals(Object o) {
        return equals(o);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractId that = (AbstractId) o;

        return Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(id);
    }
}
