package com.valor.vod.meta.model.database.ddo.media.base;


import com.google.common.base.Objects;

import javax.persistence.Column;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;

/**
 * Created by ll on 2015/10/5.
 */
@MappedSuperclass
public abstract class AbstractMediaLocale extends AbstractLocaleId {
    @Column(name = "title", nullable = false, length = 255)
    private String title = "";

    @Column(name = "title_sort", nullable = false, length = 255)
    private String titleSort = "";

    @Lob
    @Column(name = "plot", columnDefinition = "text")
    private String plot = "";

    @Lob
    @Column(name = "taglines", columnDefinition = "text")
    private String taglines = "";

    @Lob
    @Column(name = "quote", columnDefinition = "text")
    private String quote;

    @Column(name = "poster")
    private String poster;

    @Column(name = "backdrop")
    private String backdrop;

    public String getQuote() {
        return quote;
    }

    public void setQuote(String quote) {
        this.quote = quote;
    }

    public String getPoster() {
        return poster;
    }

    public void setPoster(String poster) {
        this.poster = poster;
    }

    public String getBackdrop() {
        return backdrop;
    }

    public void setBackdrop(String backdrop) {
        this.backdrop = backdrop;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitleSort() {
        return titleSort;
    }

    public void setTitleSort(String titleSort) {
        this.titleSort = titleSort;
    }

    public String getPlot() {
        return plot;
    }

    public void setPlot(String plot) {
        this.plot = plot;
    }

    public String getTaglines() {
        return taglines;
    }

    public void setTaglines(String taglines) {
        this.taglines = taglines;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractMediaLocale that = (AbstractMediaLocale) o;

        return Objects.equal(this.language, that.language) &&
            Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(language, id);
    }
}
