package com.valor.vod.meta.model.database.ddo.media.base;

import com.google.common.base.Objects;
import com.valor.vod.common.tools.type.DdoKeyTools;

import javax.persistence.Column;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/4/29.
 */
@MappedSuperclass
public class AbstractSynopsis extends AbstractLocaleId {
    @Column(name = "title")
    private String title = "";

    @Column(name = "type")
    private String type = "";

    @Column(name = "year")
    private String year = "";

    @Lob
    @Column(name = "text", length = 25000)
    private String text = "";

    @Column(name = "source")
    private String source = "";

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractSynopsis that = (AbstractSynopsis) o;

        return Objects.equal(this.language, that.language) &&
            Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(language, id);
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(id, language);
    }

    @Override
    public boolean valueEquals(Object o) {
        if (!equals(o)) {
            return false;
        } else {
            AbstractSynopsis that = (AbstractSynopsis) o;

            return Objects.equal(this.title, that.title)
                && Objects.equal(this.year, that.year)
                && Objects.equal(this.type, that.type)
                && Objects.equal(this.source, that.source)
                && Objects.equal(this.text, that.text);
        }
    }
}
