package com.valor.vod.meta.model.database.ddo.media.base;

import com.google.common.base.Objects;
import com.valor.vod.common.tools.type.DdoKeyTools;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/4/28.
 */
@MappedSuperclass
public class AbstractTrailer extends AbstractLocaleId {

    @Id
    @Column(name = "source", nullable = true, length = 255)
    public String source = "";

    @Id
    @Column(name = "key_str", nullable = true, length = 255)
    public String keyStr = "";

    @Column(name = "title", length = 255)
    protected String title = "";

    @Column(name = "size", nullable = false)
    protected int size = 0;

    @Column(name = "type", nullable = true, length = 50)
    protected String type = "";

    @Column(name = "url", length = 1024)
    protected String url = "";

    @Id
    @Column(name = "trailer_primary", nullable = false)
    protected int trailerPrimary = 0;

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getKeyStr() {
        return keyStr;
    }

    public void setKeyStr(String keyStr) {
        this.keyStr = keyStr;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getSize() {
        return size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getTrailerPrimary() {
        return trailerPrimary;
    }

    public void setTrailerPrimary(int trailerPrimary) {
        this.trailerPrimary = trailerPrimary;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractTrailer that = (AbstractTrailer) o;

        return Objects.equal(this.source, that.source) &&
            Objects.equal(this.keyStr, that.keyStr) &&
            Objects.equal(this.language, that.language) &&
            Objects.equal(this.id, that.id) &&
            Objects.equal(this.trailerPrimary, that.trailerPrimary);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(source, keyStr, language, id, trailerPrimary);
    }


    @Override
    public String valueKey() {
        return DdoKeyTools.key(id, language, source, keyStr, trailerPrimary);
    }

    @Override
    public boolean valueEquals(Object o) {
        if (!equals(o)) {
            return false;
        } else {
            AbstractTrailer that = (AbstractTrailer) o;
            return Objects.equal(this.title, that.title) &&
                Objects.equal(this.size, that.size) &&
                Objects.equal(this.type, that.type);
        }
    }
}
