package com.valor.vod.meta.model.database.ddo.media.common;

import com.valor.vod.common.database.model.AbstractLMI;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;

/**
 * Created by Frank.Huang on 2016/4/29.
 */
@Entity
@Table(name = "search_keyword")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class SearchKeyword extends AbstractLMI {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id", columnDefinition = "bigint(20) COMMENT '全局唯一ID'")
    private long id;
    @Column(name = "language", columnDefinition = "varchar(10) DEFAULT '' COMMENT '语种简写'")
    private String language;
    @Column(name = "keyword", columnDefinition = "varchar(128) DEFAULT '' COMMENT '搜索关键词'")
    private String keyword;
    @Column(name = "weight", columnDefinition = "int(11) DEFAULT 0 COMMENT '关键词权重（越大越优先）'")
    private Integer weight;
    @Column(name = "type", columnDefinition = "tinyint(4) DEFAULT 0 COMMENT '事件类型 （0正常搜索  1跳转url）'")
    private Integer type;
    @Column(name = "url", columnDefinition = "varchar(512) DEFAULT '' COMMENT '跳转url（只有type为1时才有）'")
    private String url;
    @Column(name = "device_type", columnDefinition = "tinyint(4) DEFAULT -1 COMMENT '设备类型（-1 全设备 0 box 1 phone）'")
    private Integer deviceType;


    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public Integer getWeight() {
        return weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(Integer deviceType) {
        this.deviceType = deviceType;
    }
}
