package com.valor.vod.meta.model.database.ddo.media.tv;

import com.google.common.base.Objects;
import com.valor.vod.meta.model.database.ddo.media.base.AbstractMedia;
import com.valor.vod.common.tools.type.DdoKeyTools;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

//@Entity
//@Table(name = "vms_season")
//@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
//@SuppressWarnings("unused")
public class Season extends AbstractMedia {
//    @Column(name = "season", nullable = false)
    private int season;

//    @Column(name = "series_id")
    private long seriesId;

//    @Column(name = "first_air_date", length = 16)
    private String firstAirDate = "";


//    @Column(name = "last_air_date", length = 16)
    private String lastAirDate = "";

    public int getSeason() {
        return season;
    }

    public void setSeason(int season) {
        this.season = season;
    }

    public long getSeriesId() {
        return seriesId;
    }

    public void setSeriesId(long seriesId) {
        this.seriesId = seriesId;
    }

    public String getFirstAirDate() {
        return firstAirDate;
    }

    public void setFirstAirDate(String firstAirDate) {
        this.firstAirDate = firstAirDate;
    }

    public String getLastAirDate() {
        return lastAirDate;
    }

    public void setLastAirDate(String lastAirDate) {
        this.lastAirDate = lastAirDate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Season that = (Season) o;

        return Objects.equal(this.seriesId, that.seriesId) &&
            Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(seriesId, id);
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(seriesId, season);
    }

    @Override
    public boolean valueEquals(Object o) {
        if (!equals(o)) {
            return false;
        } else {
            Season that = (Season) o;

            return Objects.equal(this.firstAirDate, that.firstAirDate)
                && Objects.equal(this.lastAirDate, that.lastAirDate);
        }
    }
}
