package com.valor.vod.meta.model.database.ddo.ops.dbg;

import com.valor.vod.common.database.model.AbstractLMI;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * Created by Frank.Huang on 2018/6/25.
 */
@Entity
@Table(name = "vms_dbg_meta_subtitle")
public class MetaSubtitleDdo extends AbstractLMI {
    /**
     * 0:init value
     */
    public static final int STATUS_INIT = 0;
    /**
     * 1:some subtitles has done
     */
    public static final int STATUS_PART_DONE = 1;
    /**
     * 2:all subtitles has done.
     */
    public static final int STATUS_ALL_DONE = 2;
    /**
     * There is only three languages now!
     * languages:en(English)、pt(Portuguese)、es(Spanish).
     */
    public static final int LANG_TYPES = (1 << 3) - 1;
    @Column(name = "uid")
    private long uid = 0;
    /**
     * movie id
     */
    @Id
    @Column(name = "meta_id")
    private long metaId = 0;

    /**
     * TV series season id
     */
    @Id
    @Column(name = "season_id")
    private long seasonId = 0;

    /**
     * TV series episode id
     */
    @Id
    @Column(name = "episode_id")
    private long episodeId = 0;

    /**
     * device id
     */
    @Column(name = "did", length = 64)
    private String did = "";

    @Column(name = "status", columnDefinition = "int default 0")
    private int status = 0;

    public long getUid() {
        return uid;
    }

    public void setUid(long uid) {
        this.uid = uid;
    }

    public long getMetaId() {
        return metaId;
    }

    public void setMetaId(long metaId) {
        this.metaId = metaId;
    }

    public String getDid() {
        return did;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public long getSeasonId() {
        return seasonId;
    }

    public void setSeasonId(long seasonId) {
        this.seasonId = seasonId;
    }

    public long getEpisodeId() {
        return episodeId;
    }

    public void setEpisodeId(long episodeId) {
        this.episodeId = episodeId;
    }
}
