package com.valor.vod.meta.model.database.ddo.person;

import com.google.common.base.Objects;
import com.valor.vod.meta.model.database.ddo.media.base.AbstractLocaleId;
import com.valor.vod.common.tools.type.DdoKeyTools;

import javax.persistence.Column;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/8/3.
 */
@MappedSuperclass
public class AbstractPersonLocale extends AbstractLocaleId {
    @Column(name = "name", length = 255)
    private String name = "";

    @Column(name = "birth_name", length = 128)
    private String birthName = "";

    @Lob
    @Column(name = "biography", columnDefinition = "text")
    private String biography = "";

    @Column(name = "photo")
    private String photo = "";

    @Column(name = "photo_source")
    private String photoSource = "";

    @Column(name = "photo_url", length = 512)
    private String photoUrl = "";

    @Column(name = "birth_place", length = 128)
    private String birthPlace = "";


    public String getBirthName() {
        return birthName;
    }

    public void setBirthName(String birthName) {
        this.birthName = birthName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBiography() {
        return biography;
    }

    public void setBiography(String biography) {
        this.biography = biography;
    }

    public String getPhoto() {
        return photo;
    }

    public void setPhoto(String photo) {
        this.photo = photo;
    }

    public String getPhotoSource() {
        return photoSource;
    }

    public void setPhotoSource(String photoSource) {
        this.photoSource = photoSource;
    }

    public String getPhotoUrl() {
        return photoUrl;
    }

    public void setPhotoUrl(String photoUrl) {
        this.photoUrl = photoUrl;
    }

    public String getBirthPlace() {
        return birthPlace;
    }

    public void setBirthPlace(String birthPlace) {
        this.birthPlace = birthPlace;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractPersonLocale that = (AbstractPersonLocale) o;

        return Objects.equal(this.language, that.language) &&
            Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(language, id);
    }


    @Override
    public String valueKey() {
        return DdoKeyTools.key(id, language);
    }

    @Override
    public boolean valueEquals(Object o) {
        if (!equals(o)) {
            return false;
        } else {
            AbstractPersonLocale that = (AbstractPersonLocale) o;

            return Objects.equal(this.name, that.name)
                && Objects.equal(this.birthName, that.birthName)
                && Objects.equal(this.biography, that.biography)
                && Objects.equal(this.birthPlace, that.birthPlace)
                && Objects.equal(this.photo, that.photo)
                && Objects.equal(this.photoSource, that.photoSource)
                && Objects.equal(this.photoUrl, that.photoUrl);
        }
    }
}
