package com.valor.vod.meta.model.database.ddo.person;

import lombok.Data;
import org.hibernate.annotations.SQLInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * @author Damon.Gao
 * @date 2022/3/4 17:07
 */
@Entity
@Table(name = "person_for_query")
@Data
@SQLInsert(sql = "INSERT INTO person_for_query (disable, id) VALUES (?, ?) ON DUPLICATE KEY UPDATE disable=values(disable)")
public class Person4Query {
    @Id
    @Column(name = "id")
    private Long id;

    @Column(name = "create_time", insertable = false, updatable = false)
    private LocalDateTime createTime;

    @Column(name = "update_time", insertable = false, updatable = false)
    private LocalDateTime updateTime;

    /**
     * 是否启用,1=禁用,0=启用
     */
    @Column(name = "disable", columnDefinition = "tinyint(4) DEFAULT NULL")
    private int disable;

}
