package com.valor.vod.meta.model.database.ddo.person;

import com.google.common.base.Objects;
import com.valor.vod.meta.model.database.ddo.media.base.AbstractId;
import com.valor.vod.common.tools.type.DdoKeyTools;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;

//@Entity
//@Table(name = "vms_person_tag", indexes = {@Index(name = "pcIdIndex", columnList = "pc_id")})
//@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class PersonTag extends AbstractId {
//    @Column(name = "pc_id", nullable = false, columnDefinition = "varchar(16) COMMENT '人物编号'")
    private String pcId;
//    @Id
//    @Column(name = "tag_id", nullable = false, columnDefinition = "int(11) COMMENT '标签ID'")
    private int tagId;
//    @Column(name = "en_tag", nullable = false, columnDefinition = "varchar(255) COMMENT '标签'")
    private String enTag;
//    @Column(name = "category", nullable = false, columnDefinition = "int(11) COMMENT '标签分类(1 job, 2 other)'")
    private int category;

    public PersonTag() {
    }

    public PersonTag(String pcId, int tagId, String enTag, int category) {
        this.pcId = pcId;
        this.tagId = tagId;
        this.enTag = enTag;
        this.category = category;
    }

    public String getPcId() {
        return pcId;
    }

    public void setPcId(String pcId) {
        this.pcId = pcId;
    }

    public int getTagId() {
        return tagId;
    }

    public void setTagId(int tagId) {
        this.tagId = tagId;
    }

    public String getEnTag() {
        return enTag;
    }

    public void setEnTag(String enTag) {
        this.enTag = enTag;
    }

    public int getCategory() {
        return category;
    }

    public void setCategory(int category) {
        this.category = category;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PersonTag that = (PersonTag) o;

        return Objects.equal(this.id, that.id) &&
            Objects.equal(this.tagId, that.tagId);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(id, tagId);
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(id, tagId);
    }

    @Override
    public boolean valueEquals(Object o) {
        if (!equals(o)) {
            return false;
        } else {
            PersonTag that = (PersonTag) o;

            return Objects.equal(this.id, that.id)
                && Objects.equal(this.tagId, that.tagId);
        }
    }
}
