package com.valor.vod.meta.model.database.ddo.playlist;

import com.valor.vod.meta.model.database.constants.playlist.*;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * playlist主表
 *
 * @author Damon.Gao
 * @date 2021/7/27 14:29
 */
@Entity
@Data
@Table(name = "playlist")
public class PlaylistDDO implements Serializable {

    @Id
    @Column(name = "id")
    private Long id;

    @Column(name = "name")
    private String name;

    @Column(name = "list_type")
    @Enumerated(EnumType.STRING)
    private EPlaylistListType listType;

    @Column(name = "source_type")
    private String sourceType;

    @Column(name = "sub_type")
    private String subType;

    @Column(name = "sub_type2")
    private String subType2;

    @Column(name = "extra_type")
    private String extraType;

    @Column(name = "ref_id")
    private Long refId;

    /**
     * PP的列表ID
     */
    @Column(name = "original_id")
    private String originalId;

    /**
     * 是否可以过滤
     */
    @Column(name = "can_filter", columnDefinition = "smallint")
    private Integer canFilter;

    @Column(name = "target")
    private String target;

    @Column(name = "extra", columnDefinition = "text")
    private String extra;

    @Column(name = "price_type")
    private String priceType;

    @Column(name = "price")
    private Integer price;

    @Column(name = "description")
    private String description;

    @Column(name = "status")
    private String status;

    @Column(name = "sync_status")
    private String syncStatus;

    @Column(name = "create_user")
    private Integer createUser;

    @Column(name = "create_time", insertable = false, updatable = false)
    private LocalDateTime createTime;

    @Column(name = "update_user")
    private Integer updateUser;

    @Column(name = "update_time", insertable = false, updatable = false)
    private LocalDateTime updateTime;

}
