package com.valor.vod.meta.model.database.ddo.playlist;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * playlist国际化信息表
 *
 * @author Damon.Gao
 * @date 2021/7/27 15:19
 */
@Entity
@Data
@Table(name = "playlist_i18n")
public class PlaylistI18nDDO implements Serializable {

    @Id
    @Column(name = "playlist_id")
    private Long playlistId;

    @Id
    @Column(name = "language")
    private String language;

    @Column(name = "title")
    private String title;

    @Column(name = "poster")
    private String poster;

    @Column(name = "backdrop")
    private String backdrop;

    @Column(name = "background_image")
    private String backgroundImage;

    @Column(name = "ico_normal")
    private String icoNormal;

    @Column(name = "ico_focus")
    private String icoFocus;

    @Column(name = "create_user")
    private Integer createUser;

    @Column(name = "create_time", insertable = false, updatable = false)
    private LocalDateTime createTime;

    @Column(name = "update_user")
    private Integer updateUser;

    @Column(name = "update_time", insertable = false, updatable = false)
    private LocalDateTime updateTime;

}
