package com.valor.vod.meta.model.database.ddo.playlist;

import com.valor.vod.meta.model.database.constants.playlist.EPlaylistNodeStatus;
import com.valor.vod.meta.model.database.constants.playlist.EPlaylistNodeType;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * playlist节点表
 *
 * @author Damon.Gao
 * @date 2021/7/27 15:57
 */
@Entity
@Data
@Table(name = "playlist_node")
public class PlaylistNodeDDO implements Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id", updatable = false, nullable = false)
    private Long id;

    /**
     * 节点所属的playlist_id
     */
    @Column(name = "parent_playlist_id")
    private Long parentPlaylistId;

    @Column(name = "node_type")
    @Enumerated(EnumType.STRING)
    private EPlaylistNodeType nodeType;

    /**
     * 子节点的vms_id，playlist_id/video_id/person_id
     */
    @Column(name = "vms_id")
    private Long vmsId;

    @Column(name = "original_id")
    private String originalId;

    @Column(name = "title")
    private String title;

    @Column(name = "sort_no")
    private Integer sortNo;

    @Column(name = "status")
    @Enumerated(EnumType.STRING)
    private EPlaylistNodeStatus status;

    @Column(name = "extra")
    private String extra;

    @Column(name = "create_user")
    private Integer createUser;

    @Column(name = "create_time", insertable = false, updatable = false)
    private LocalDateTime createTime;

    @Column(name = "update_user")
    private Integer updateUser;

    @Column(name = "update_time", insertable = false, updatable = false)
    private LocalDateTime updateTime;
}
