package com.valor.vod.meta.model.database.ddo.playlist.audio;

import com.google.common.base.Objects;
import com.valor.vod.api.model.constant.EVideoType;
import com.valor.vod.meta.model.database.ddo.media.base.AbstractId;
import com.valor.vod.common.tools.type.DdoKeyTools;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;

/**
 * Created by charlie on 2018/12/12.
 */
@Entity
@Table(name = "playlist_second_audio", indexes = {
    @Index(name = "index_id", columnList = "id"),
    @Index(name = "index_imdb_id", columnList = "imdb_id"),
    @Index(name = "index_cid", columnList = "cid"),
    @Index(name = "index_language", columnList = "language"),
    @Index(name = "index_media_type", columnList = "media_type"),
    @Index(name = "index_linked_time", columnList = "linked_time"),
    @Index(name = "index_popularity", columnList = "popularity"),
    @Index(name = "index_rating", columnList = "rating"),
    @Index(name = "index_WR", columnList = "WR"),
    @Index(name = "index_last_modify_time", columnList = "last_modify_time"),
    @Index(name = "index_release_date_int", columnList = "release_date_int")
})
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class PlaylistSecondAudio extends AbstractId {

    @Id
    @Column(name = "cid")
    public Long cid;

    @Id
    @Column(name = "language", length = 16)
    public String language = "";
    @Column(name = "media_type")
    public EVideoType mediaType;
    @Column(name = "popularity", columnDefinition = "double(20,4) default 0.0")
    protected double popularity = 0.0;
    @Column(name = "rating", columnDefinition = "double(9,1) default 0.0")
    protected double rating = 0.0;
    @Column(name = "WR", columnDefinition = "double(9,1) default 0.0")
    protected double WR = 0.0;
    @Column(name = "imdb_id", length = 16)
    private String imdbId;
    @Column(name = "linked_time")
    private long LinkedTime = 0;

    @Column(name = "release_date_int")
    private int releaseDateInt = 0;

    public Long getCid() {
        return cid;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getImdbId() {
        return imdbId;
    }

    public void setImdbId(String imdbId) {
        this.imdbId = imdbId;
    }

    public EVideoType getMediaType() {
        return mediaType;
    }

    public void setMediaType(EVideoType mediaType) {
        this.mediaType = mediaType;
    }

    public double getPopularity() {
        return popularity;
    }

    public void setPopularity(double popularity) {
        this.popularity = popularity;
    }

    public double getRating() {
        return rating;
    }

    public void setRating(double rating) {
        this.rating = rating;
    }

    public double getWR() {
        return WR;
    }

    public void setWR(double WR) {
        this.WR = WR;
    }

    public long getLinkedTime() {
        return LinkedTime;
    }

    public void setLinkedTime(long linkedTime) {
        LinkedTime = linkedTime;
    }

    public int getReleaseDateInt() {
        return releaseDateInt;
    }

    public void setReleaseDateInt(int releaseDateInt) {
        this.releaseDateInt = releaseDateInt;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PlaylistSecondAudio that = (PlaylistSecondAudio) o;

        return Objects.equal(this.cid, that.cid) &&
            Objects.equal(this.language, that.language) &&
            Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(cid, language, id);
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(id, language, cid);
    }

    @Override
    public boolean valueEquals(Object o) {
        if (!equals(o)) {
            return false;
        } else {
            PlaylistSecondAudio that = (PlaylistSecondAudio) o;
            return Objects.equal(this.id, that.id)
                && Objects.equal(this.language, that.language)
                && Objects.equal(this.cid, that.cid)
                && Objects.equal(this.mediaType, that.mediaType)
                && Objects.equal(this.popularity, that.popularity)
                && Objects.equal(this.rating, that.rating)
                && Objects.equal(this.WR, that.WR)
                && Objects.equal(this.LinkedTime, that.LinkedTime)
                && Objects.equal(this.releaseDateInt, that.releaseDateInt)
                && Objects.equal(this.imdbId, that.imdbId);
        }
    }

}
