package com.valor.vod.meta.model.database.ddo.sync;

import com.valor.vod.common.database.model.AbstractLMI;
import org.hibernate.annotations.SQLInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * @auther Chris.Zeng
 * @date 2020/5/11 17:24
 */
@Entity
@Table(name = "sync_task_recv")
@SQLInsert(sql="INSERT INTO sync_task_recv(create_time, last_modify_user, " +
    "command, sourceType, task_type, type, task_id, id) " +
    "VALUES (?, ?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE task_type = values(task_type), " +
    "type=values(type), command=values(command), sourceType=values(sourceType), " +
    "last_modify_user=values(last_modify_user)" )
public class SyncTaskRecv extends AbstractLMI {

    @Id
    @Column(name = "task_id", columnDefinition = "int(15) COMMENT '任务id'", length = 15)
    protected long taskId = 0;

    @Column(name = "task_type", columnDefinition = "int(15) COMMENT '任务类型'", length = 15)
    protected int taskType = 0;

    @Id
    @Column(name = "id", columnDefinition = "varchar(2047) COMMENT '接收的参数id'")
    protected String id;

    @Column(name = "type", columnDefinition = "int(7) COMMENT '接收的参数类型'", length = 7)
    protected int type = 0;

    @Column(name = "command", columnDefinition = "int(15) COMMENT '任务操作类型'", length = 15)
    protected int command = 0;

    @Column(name = "sourceType", columnDefinition = "int(15) COMMENT 'sourceType'", length = 15)
    protected int sourceType = 0;

    public long getTaskId() {
        return taskId;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public int getTaskType() {
        return taskType;
    }

    public void setTaskType(int taskType) {
        this.taskType = taskType;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getCommand() {
        return command;
    }

    public void setCommand(int command) {
        this.command = command;
    }

    public int getSourceType() {
        return sourceType;
    }

    public void setSourceType(int sourceType) {
        this.sourceType = sourceType;
    }
}
