package com.valor.vod.meta.model.database.tools.media;

import com.google.common.base.Strings;

/**
 * Created by Frank.Huang on 2016/10/11.
 */
public enum EMovieCertificateUS {
    NR("NR", 0),
    G("G", 100),
    PG("PG", 101),
    PG_13("PG-13", 102),
    R("R", 103),
    NC_17("NC-17", 104),
    X("X", 104),
    ;

    private String k;
    private int v;

    EMovieCertificateUS(String k, int v) {
        this.k = k;
        this.v = v;
    }

    public static EMovieCertificateUS stringValueOf(String k) {
        if (!Strings.isNullOrEmpty(k)) {
            for (EMovieCertificateUS e : values()) {
                if (e.k.equalsIgnoreCase(k)) {
                    return e;
                }
            }
        }

        return EMovieCertificateUS.NR;
    }

    public boolean lt(EMovieCertificateUS c1) {
        return v < c1.v;
    }

    public boolean le(EMovieCertificateUS c1) {
        return v <= c1.v;
    }

    public boolean ge(EMovieCertificateUS c1) {
        return v >= c1.v;
    }

    public boolean gt(EMovieCertificateUS c1) {
        return v > c1.v;
    }

    public boolean lt(String k) {
        return lt(stringValueOf(k));
    }

    public boolean gt(String k) {
        return gt(stringValueOf(k));
    }

    public boolean le(String k) {
        return le(stringValueOf(k));
    }
}
