package com.valor.vod.meta.model.service;

import com.google.common.collect.Maps;
import com.valor.vod.meta.model.database.dao.MetaDao;
import com.valor.vod.meta.model.database.ddo.base.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.util.Map;
import java.util.Set;

/**
 * Created by Frank.Huang on 2016/6/16.
 */
//@Service
public class AttributeService {
    private static final Logger logger = LoggerFactory.getLogger(AttributeService.class);
    private static Map<Long, String> attributeMap = Maps.newConcurrentMap();
    private static Map<String, Long> attributeIdMap = Maps.newConcurrentMap();
    @Autowired
    private MetaDao metaDao;

//    @PostConstruct
    public void loadFromDB() {
        Set<Attribute> values = metaDao.getSetData(false, Attribute.class, null);
        if (!values.isEmpty()) {
            values.forEach(e -> {
                attributeMap.put(e.getId(), e.getAttr());
                attributeIdMap.put(e.getAttr(), e.getId());
            });
            logger.info("Load [{}]  attributes from database", attributeMap.size());
        }
    }

    public String getAttr(long id) {
        return attributeMap.getOrDefault(id, "");
    }

    public long getAttrId(String attr) {
        return attributeIdMap.getOrDefault(attr, -1L);
    }
}
