/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.model.database.tools.media;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.valor.vod.api.model.constant.EArtworkType;
import com.valor.vod.api.model.constant.EVideoType;
import com.valor.vod.common.tools.meta.LanguageTools;
import com.valor.vod.common.tools.type.CollectionUtils;
import com.valor.vod.common.tools.type.DateTimeTools;
import com.valor.vod.meta.model.database.constants.EMetaModifyProperty;
import com.valor.vod.meta.model.database.constants.EMetaProperty;
import com.valor.vod.meta.model.database.ddo.media.Meta4Query;
import com.valor.vod.meta.model.database.ddo.media.base.AbstractArtwork;
import com.valor.vod.meta.model.database.ddo.media.base.AbstractCertification;
import com.valor.vod.meta.model.database.ddo.media.base.AbstractCountry;
import com.valor.vod.meta.model.database.ddo.media.base.AbstractGenre;
import com.valor.vod.meta.model.database.ddo.media.base.AbstractMedia;
import com.valor.vod.meta.model.database.ddo.media.tv.Series;
import com.valor.vod.meta.model.database.ddo.media.tv.TVSeriesCertification;
import com.valor.vod.meta.model.database.ddo.media.video.Video;
import com.valor.vod.meta.model.database.ddo.media.video.VideoCertification;
import com.valor.vod.meta.model.database.tools.BitTools;
import com.valor.vod.meta.model.database.tools.media.EMovieCertificateUS;
import com.valor.vod.meta.model.database.tools.media.ETVCertificateUS;
import com.valor.vod.meta.model.database.tools.media.MetaFlagWrapper;
import com.valor.vod.meta.model.database.tools.media.MetaModifyFlagWrapper;
import com.valor.vod.meta.model.database.tools.media.SortScoreTools;
import com.valor.vod.meta.model.service.SyncFieldTools;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Meta4QueryWrapper {
    private static final String KEY_FAMILY_GENRE = "KEY_FAMILY_GENRE";
    private static final String KEY_FAMILY_CERT = "KEY_FAMILY_CERT";
    private static Set<Long> GENRE_FAMILY = ImmutableSet.of((Object)8L);
    private static Set<Long> GENRE_FAMILY_EXCLUDE = ImmutableSet.of((Object)12L);
    private static Set<Long> GENRE_ANIMATION = ImmutableSet.of((Object)3L);
    private static Set<Long> REGION_US = ImmutableSet.of((Object)227L);
    private static Set<Long> REGION_LATIN = ImmutableSet.of((Object)10L, (Object)26L, (Object)30L, (Object)43L, (Object)47L, (Object)52L, (Object[])new Long[]{55L, 61L, 63L, 65L, 76L, 88L, 90L, 94L, 96L, 133L, 137L, 154L, 166L, 168L, 169L, 173L, 174L, 198L, 229L, 233L});
    private static Set<Long> REGION_ASIA = ImmutableSet.of((Object)44L, (Object)97L, (Object)100L, (Object)109L, (Object)197L, (Object)209L, (Object[])new Long[0]);
    private Meta4Query meta4Query;
    private MetaFlagWrapper flagWrapper = new MetaFlagWrapper();
    private String field = "";
    private Map<String, Integer> familyMap = Maps.newHashMap();

    public Meta4QueryWrapper(Meta4Query meta4Query, String field) {
        this.field = field;
        if (meta4Query != null) {
            this.meta4Query = meta4Query;
            this.meta4Query.setLastModifyTime(new Date());
        } else {
            this.meta4Query = new Meta4Query();
        }
        this.meta4Query.setToBeDel(99999);
    }

    private boolean isTV() {
        return this.meta4Query.getType() == EVideoType.SERIES;
    }

    private boolean isMovie() {
        return this.meta4Query.getType() == EVideoType.MOVIE;
    }

    private boolean isTVReduceWight() {
        return this.isTV() && this.meta4Query.getIsAsia() == 1;
    }

    private boolean isReduceWight(String field, int rating, int hasArtwork) {
        if (SyncFieldTools.isMeta(field) && rating <= 0 || !BitTools.isSet(hasArtwork, 1)) {
            return true;
        }
        return SyncFieldTools.isImage(field) && !BitTools.isSet(hasArtwork, 1) || rating <= 0;
    }

    private Meta4Query updateSortFactor() {
        int sortScore;
        if (this.isReduceWight(this.field, this.meta4Query.getRating(), this.meta4Query.getHasArtwork()) && (sortScore = SortScoreTools.getSortScore(this.meta4Query)) != this.meta4Query.getReleaseDate()) {
            if (sortScore >= 0) {
                sortScore -= 99999999;
            }
            if (this.meta4Query.getReleaseDate() != sortScore) {
                this.meta4Query.setToBeDel(0);
                this.meta4Query.setReleaseDate(sortScore);
            }
            if (this.meta4Query.getPopularity() != (long)sortScore) {
                this.meta4Query.setToBeDel(0);
                this.meta4Query.setPopularity(sortScore);
            }
            if (this.meta4Query.getWeightRating() != sortScore) {
                this.meta4Query.setToBeDel(0);
                this.meta4Query.setWeightRating(sortScore);
            }
            if (this.isTVReduceWight() && this.meta4Query.getLastAirDate() != sortScore) {
                this.meta4Query.setLastAirDate(sortScore);
                this.meta4Query.setToBeDel(0);
            }
        }
        return this.meta4Query;
    }

    public Meta4Query getMeta4Query() {
        this.updateSortFactor();
        this.meta4Query.setLastModifyTime(new Date());
        return this.meta4Query;
    }

    public void setMeta4Query(Meta4Query meta4Query) {
        this.meta4Query = meta4Query;
    }

    public int getMetaFlag() {
        return this.flagWrapper.getMetaFlag();
    }

    public int getModifyFlag() {
        return this.flagWrapper.getModifyFlag();
    }

    public void updateMetaFlag(AbstractMedia media) {
        int hasEnglish;
        int lastAirDate;
        int hasRuntime;
        this.meta4Query.setId(media.getId());
        if (this.meta4Query.getType() != media.getType()) {
            this.meta4Query.setToBeDel(0);
            this.meta4Query.setType(media.getType());
        }
        if (!this.meta4Query.getMetaId().equalsIgnoreCase(media.getMetaId())) {
            this.meta4Query.setToBeDel(0);
            this.meta4Query.setMetaId(media.getMetaId());
        }
        if (this.meta4Query.getReleaseDate() != media.getReleaseDateInt()) {
            this.meta4Query.setToBeDel(0);
            this.meta4Query.setReleaseDate(media.getReleaseDateInt());
        }
        long popularity = Double.valueOf(media.getPopularity()).longValue();
        if (this.meta4Query.getPopularity() != popularity) {
            this.meta4Query.setToBeDel(0);
            this.meta4Query.setPopularity(popularity);
        }
        int wr = (int)(media.getWR() * 10000.0);
        if (this.meta4Query.getWeightRating() != wr) {
            this.meta4Query.setToBeDel(0);
            this.meta4Query.setWeightRating(wr);
        }
        int rating = (int)(media.getRating() * 10.0);
        if (this.meta4Query.getRating() != rating) {
            this.meta4Query.setToBeDel(0);
            this.meta4Query.setRating(rating);
        }
        if (this.meta4Query.getYear() != media.getPublicationYear()) {
            this.meta4Query.setToBeDel(0);
            this.meta4Query.setYear(media.getPublicationYear());
        }
        int n = hasRuntime = media.getRuntime() > 0L ? 1 : 0;
        if (this.meta4Query.getHasRuntime() != hasRuntime) {
            this.meta4Query.setToBeDel(0);
            this.meta4Query.setHasRuntime(hasRuntime);
        }
        if (this.meta4Query.getVoteCount() != media.getVoteCount()) {
            this.meta4Query.setToBeDel(0);
            this.meta4Query.setVoteCount(media.getVoteCount());
        }
        int adult = 0;
        if (media.getAdult() == 1 || BitTools.isSet(media.getComplete(), EMetaProperty.META_PORNOGRAPHIC.getValue())) {
            adult = 1;
        }
        if (this.meta4Query.getAdult() != adult) {
            this.meta4Query.setToBeDel(0);
            this.meta4Query.setAdult(adult);
        }
        if (media instanceof Series) {
            lastAirDate = DateTimeTools.date2IntVal((String)((Series)media).getLastAirDate());
            if (this.meta4Query.getLastAirDate() != lastAirDate) {
                this.meta4Query.setLastAirDate(lastAirDate);
                this.meta4Query.setToBeDel(0);
            }
        } else if (media instanceof Video) {
            lastAirDate = ((Video)media).getReleaseDateInt();
            if (this.meta4Query.getLastAirDate() != lastAirDate) {
                this.meta4Query.setLastAirDate(lastAirDate);
                this.meta4Query.setToBeDel(0);
            }
        }
        boolean isEnglish = LanguageTools.isContainEnglish((String)media.getOriginalLanguage());
        int n2 = hasEnglish = isEnglish ? 0 : 1;
        if (this.meta4Query.getLangNotContainsEn() != hasEnglish) {
            this.meta4Query.setLangNotContainsEn(hasEnglish);
            this.meta4Query.setToBeDel(0);
        }
    }

    private void updateFamily() {
        if (this.familyMap.size() != 2) {
            return;
        }
        int v = this.familyMap.getOrDefault(KEY_FAMILY_GENRE, 0) & this.familyMap.getOrDefault(KEY_FAMILY_CERT, 0);
        if (this.meta4Query.getIsFamily() != v) {
            this.meta4Query.setIsFamily(v);
            this.meta4Query.setToBeDel(0);
            if (v == 1) {
                this.flagWrapper.setMetaFlag(EMetaProperty.META_FAMILY_FILM);
            } else {
                this.flagWrapper.clsMetaFlag(EMetaProperty.META_FAMILY_FILM);
            }
        }
    }

    public void updateCertFlag(Set set) {
        if (!SyncFieldTools.isMeta(this.field)) {
            return;
        }
        if (!CollectionUtils.isNullOrEmpty((Collection)set)) {
            for (Object e : set) {
                AbstractCertification c = (AbstractCertification)((Object)e);
                if (!"us".equalsIgnoreCase(c.countryCode.toLowerCase())) continue;
                if (e instanceof VideoCertification && EMovieCertificateUS.PG_13.le(c.getCertificate())) {
                    this.familyMap.put(KEY_FAMILY_CERT, 0);
                }
                if (!(e instanceof TVSeriesCertification) || !ETVCertificateUS.TV_14.le(c.getCertificate())) continue;
                this.familyMap.put(KEY_FAMILY_CERT, 0);
            }
        } else {
            this.familyMap.put(KEY_FAMILY_CERT, 1);
        }
        this.updateFamily();
    }

    public void updateGenreFlag(Set genreSet) {
        if (!SyncFieldTools.isMeta(this.field)) {
            return;
        }
        if (CollectionUtils.isNullOrEmpty((Collection)genreSet)) {
            this.familyMap.put(KEY_FAMILY_GENRE, 0);
            return;
        }
        HashSet genreIds = Sets.newHashSet();
        genreSet.forEach(e -> {
            AbstractGenre g = (AbstractGenre)((Object)((Object)e));
            genreIds.add(g.getDataId());
        });
        if (CollectionUtils.isContains((Set)genreIds, GENRE_FAMILY) && !CollectionUtils.isContains((Set)genreIds, GENRE_FAMILY_EXCLUDE)) {
            this.familyMap.put(KEY_FAMILY_GENRE, 1);
        } else {
            this.familyMap.put(KEY_FAMILY_GENRE, 0);
        }
        this.updateFamily();
        int isAnimation = 0;
        if (CollectionUtils.isContains((Set)genreIds, GENRE_ANIMATION)) {
            isAnimation = 1;
        }
        if (this.meta4Query.getIsAnimation() != isAnimation) {
            this.meta4Query.setIsAnimation(isAnimation);
            this.meta4Query.setToBeDel(0);
            if (isAnimation == 1) {
                this.flagWrapper.setMetaFlag(EMetaProperty.META_ANIMATION_FILM);
            } else {
                this.flagWrapper.clsMetaFlag(EMetaProperty.META_ANIMATION_FILM);
            }
        }
    }

    public void updateRegionFlag(Set set) {
        if (CollectionUtils.isNullOrEmpty((Collection)set)) {
            return;
        }
        if (!SyncFieldTools.isMeta(this.field)) {
            return;
        }
        boolean KEY_ISHOLLYWOOD = true;
        int KEY_ISLATIN = 2;
        int KEY_ISASIA = 3;
        HashMap mapRegion = Maps.newHashMap();
        set.forEach(e -> {
            AbstractCountry g = (AbstractCountry)((Object)((Object)e));
            if (REGION_US.contains(g.getDataId())) {
                mapRegion.put(1, 1);
            }
            if (REGION_LATIN.contains(g.getDataId())) {
                mapRegion.put(2, 1);
            }
            if (REGION_ASIA.contains(g.getDataId())) {
                mapRegion.put(3, 1);
            }
        });
        int isHollywood = mapRegion.getOrDefault(1, 0);
        if (this.meta4Query.getIsHollywood() != isHollywood) {
            if (isHollywood == 1) {
                this.flagWrapper.setMetaFlag(EMetaProperty.META_HOLLYWOOD_FILM);
            } else {
                this.flagWrapper.clsMetaFlag(EMetaProperty.META_HOLLYWOOD_FILM);
            }
            this.meta4Query.setIsHollywood(isHollywood);
            this.meta4Query.setToBeDel(0);
        }
        int isAsia = mapRegion.getOrDefault(3, 0);
        if (this.meta4Query.getIsAsia() != isAsia) {
            if (isAsia == 1) {
                this.flagWrapper.setMetaFlag(EMetaProperty.META_ASIA_FILM);
            } else {
                this.flagWrapper.clsMetaFlag(EMetaProperty.META_ASIA_FILM);
            }
            this.meta4Query.setIsAsia(isAsia);
            this.meta4Query.setToBeDel(0);
        }
        int isLatin = mapRegion.getOrDefault(2, 0);
        if (this.meta4Query.getIsLatin() != isLatin) {
            if (isLatin == 1) {
                this.flagWrapper.setMetaFlag(EMetaProperty.META_LATIN_FILM);
            } else {
                this.flagWrapper.clsMetaFlag(EMetaProperty.META_LATIN_FILM);
            }
            this.meta4Query.setIsLatin(isLatin);
            this.meta4Query.setToBeDel(0);
        }
    }

    public void updateArtworkFlag(Set set, MetaModifyFlagWrapper modifyFlagWrapper) {
        if (CollectionUtils.isNullOrEmpty((Collection)set)) {
            return;
        }
        int hasArtwork = this.getImageFlag2(set, modifyFlagWrapper);
        if (this.meta4Query.getHasArtwork() != hasArtwork) {
            this.meta4Query.setHasArtwork(hasArtwork);
            this.meta4Query.setToBeDel(0);
        }
    }

    public int getImageFlag2(Set set, MetaModifyFlagWrapper modifyFlagWrapper) {
        int hasArtwork = 0;
        if (modifyFlagWrapper.isFlagSet(EMetaModifyProperty.META_MODFIY_POSTTER.getValue())) {
            this.flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_POSTTER);
            hasArtwork |= EMetaProperty.META_ARTWORK_POSTTER.getValue();
        }
        if (modifyFlagWrapper.isFlagSet(EMetaModifyProperty.META_MODIFY_BACKDROP)) {
            this.flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_BACKDROP);
            hasArtwork |= EMetaProperty.META_ARTWORK_BACKDROP.getValue();
        }
        if (modifyFlagWrapper.isFlagSet(EMetaModifyProperty.META_MODFIY_POSTTER_ES.getValue())) {
            this.flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_POSTTER_ES);
            hasArtwork |= EMetaProperty.META_ARTWORK_POSTTER_ES.getValue();
        }
        if (modifyFlagWrapper.isFlagSet(EMetaModifyProperty.META_MODIFY_BACKDROP_ES)) {
            this.flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_BACKDROP_ES);
            hasArtwork |= EMetaProperty.META_ARTWORK_BACKDROP_ES.getValue();
        }
        if (modifyFlagWrapper.isFlagSet(EMetaModifyProperty.META_MODFIY_POSTTER_PT.getValue())) {
            this.flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_POSTTER_PT);
            hasArtwork |= EMetaProperty.META_ARTWORK_POSTTER_PT.getValue();
        }
        if (modifyFlagWrapper.isFlagSet(EMetaModifyProperty.META_MODIFY_BACKDROP_PT)) {
            this.flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_BACKDROP_PT);
            hasArtwork |= EMetaProperty.META_ARTWORK_BACKDROP_PT.getValue();
        }
        if (!CollectionUtils.isNullOrEmpty((Collection)set)) {
            for (Object e : set) {
                AbstractArtwork v = (AbstractArtwork)((Object)e);
                if (v.getMaster() == 1 && EArtworkType.POSTER == v.getArtworkType()) {
                    if (v.getLanguage().equalsIgnoreCase("en")) {
                        this.flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_POSTTER);
                        hasArtwork |= EMetaProperty.META_ARTWORK_POSTTER.getValue();
                    } else if (v.getLanguage().equalsIgnoreCase("es")) {
                        this.flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_POSTTER_ES);
                        hasArtwork |= EMetaProperty.META_ARTWORK_POSTTER_ES.getValue();
                    } else if (v.getLanguage().equalsIgnoreCase("pt")) {
                        this.flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_POSTTER_PT);
                        hasArtwork |= EMetaProperty.META_ARTWORK_POSTTER_PT.getValue();
                    }
                }
                if (v.getMaster() != 1 || EArtworkType.BACKDROP != v.getArtworkType()) continue;
                if (v.getLanguage().equalsIgnoreCase("en")) {
                    this.flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_BACKDROP);
                    hasArtwork |= EMetaProperty.META_ARTWORK_BACKDROP.getValue();
                    continue;
                }
                if (v.getLanguage().equalsIgnoreCase("es")) {
                    this.flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_BACKDROP_ES);
                    hasArtwork |= EMetaProperty.META_ARTWORK_BACKDROP_ES.getValue();
                    continue;
                }
                if (!v.getLanguage().equalsIgnoreCase("pt")) continue;
                this.flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_BACKDROP_PT);
                hasArtwork |= EMetaProperty.META_ARTWORK_BACKDROP_PT.getValue();
            }
        }
        return hasArtwork;
    }

    public int getImageFlag(Set set) {
        int hasArtwork = 0;
        for (Object e : set) {
            AbstractArtwork v = (AbstractArtwork)((Object)e);
            if (v.getMaster() != 1 || Strings.isNullOrEmpty((String)v.getUrl())) continue;
            if (EArtworkType.POSTER == v.getArtworkType()) {
                this.flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_POSTTER);
                hasArtwork += EMetaProperty.META_ARTWORK_POSTTER.getValue();
            }
            if (EArtworkType.BACKDROP != v.getArtworkType()) continue;
            this.flagWrapper.setMetaFlag(EMetaProperty.META_ARTWORK_BACKDROP);
            hasArtwork += EMetaProperty.META_ARTWORK_BACKDROP.getValue();
        }
        return hasArtwork;
    }
}

