/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.model.service;

import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.valor.vod.api.model.constant.EArtworkType;
import com.valor.vod.api.model.constant.EMetaSource;
import com.valor.vod.api.model.meta.media.v1.ArtworkDO;
import com.valor.vod.common.tools.meta.LanguageTools;
import com.valor.vod.common.tools.type.CollectionUtils;
import com.valor.vod.common.tools.type.DdoKeyTools;
import com.valor.vod.meta.model.database.ddo.media.base.AbstractArtwork;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArtworkQueryService {
    private Map<String, String> masterUrlMap = Maps.newHashMap();
    private Multimap<Long, AbstractArtwork> artworkMultimap = HashMultimap.create();

    public ArtworkQueryService(List<AbstractArtwork> artworks) {
        if (!CollectionUtils.isNullOrEmpty(artworks)) {
            for (AbstractArtwork artwork : artworks) {
                if (artwork.getMaster() == 1) {
                    String key = DdoKeyTools.key((Object[])new Object[]{artwork.getId(), artwork.getLanguage(), artwork.getArtworkType()});
                    this.masterUrlMap.put(key, artwork.getUrl());
                }
                this.artworkMultimap.put((Object)artwork.getId(), (Object)artwork);
            }
        }
    }

    public String getMasterArtwork(long id, String language, EArtworkType artworkType) {
        String artworkLanguage = LanguageTools.getOrDefaultLanguage((String)language);
        String key = DdoKeyTools.key((Object[])new Object[]{id, artworkLanguage, artworkType});
        String keyDefault = DdoKeyTools.key((Object[])new Object[]{id, LanguageTools.LANG_EN, artworkType});
        return this.masterUrlMap.getOrDefault(key, this.masterUrlMap.get(keyDefault));
    }

    public String getMasterArtwork(Set<Long> ids, String language, EArtworkType artworkType) {
        if (!CollectionUtils.isNullOrEmpty(ids)) {
            for (long id : ids) {
                String artwork = this.getMasterArtwork(id, language, artworkType);
                if (Strings.isNullOrEmpty((String)artwork)) continue;
                return artwork;
            }
        }
        return "";
    }

    public String getMasterPoster(long id, String language) {
        return this.getMasterArtwork(id, language, EArtworkType.POSTER);
    }

    public String getMasterBackdrop(long id, String language) {
        return this.getMasterArtwork(id, language, EArtworkType.BACKDROP);
    }

    public String getMasterPoster(Set<Long> ids, String language) {
        return this.getMasterArtwork(ids, language, EArtworkType.POSTER);
    }

    public String getMasterBackdrop(Set<Long> ids, String language) {
        return this.getMasterArtwork(ids, language, EArtworkType.BACKDROP);
    }

    public List<ArtworkDO> getArtworks(long id) {
        return this.getArtworks(id, 0, Integer.MAX_VALUE);
    }

    public List<ArtworkDO> getArtworks(long id, int min, int max) {
        Collection artworks = this.artworkMultimap.get((Object)id);
        if (CollectionUtils.isNullOrEmpty((Collection)artworks)) {
            return Lists.newArrayList();
        }
        ArrayList artworkList = Lists.newArrayList((Iterable)artworks);
        artworkList.sort(new Comparator<AbstractArtwork>(){

            @Override
            public int compare(AbstractArtwork o1, AbstractArtwork o2) {
                int score1 = ArtworkQueryService.this.calcArtworkSortScore(o1);
                int score2 = ArtworkQueryService.this.calcArtworkSortScore(o2);
                return score2 - score1;
            }
        });
        int size = artworkList.size();
        if (min >= size) {
            return Lists.newArrayList();
        }
        if (max > size) {
            max = size - 1;
        }
        ArrayList artworkDOS = Lists.newArrayList();
        for (AbstractArtwork e : artworkList.subList(min, max)) {
            artworkDOS.add(new ArtworkDO(e.getId().longValue(), e.getArtworkType(), e.getUrl(), e.getMaster()));
        }
        return artworkDOS;
    }

    private int calcArtworkSortScore(AbstractArtwork artwork) {
        int SORT_FACTOR_MASTER = 3000;
        int SORT_FACTOR_TYPE = 2000;
        int SORT_BACKDROP_SOURCE_MFC = 2000;
        int SORT_BACKDROP_SOURCE_TMDB = 1000;
        if (artwork == null) {
            return 0;
        }
        int score = 0;
        if (artwork.getMaster() == 1) {
            score += 3000;
        }
        if (artwork.getArtworkType() == EArtworkType.POSTER) {
            score += 2000;
        }
        if (artwork.getArtworkType() == EArtworkType.BACKDROP) {
            if (artwork.getSource() == EMetaSource.TMDB) {
                score += 1000;
            }
            if (artwork.getSource() == EMetaSource.VXMFC) {
                score += 2000;
            }
        }
        return score;
    }
}

