/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.model.service;

import com.google.common.collect.Maps;
import com.valor.vod.common.tools.type.CollectionUtils;
import com.valor.vod.common.tools.type.DdoKeyTools;
import com.valor.vod.meta.model.database.constants.ERefreshStatus;
import com.valor.vod.meta.model.database.dao.MetaDao;
import com.valor.vod.meta.model.database.ddo.cloud.CloudRefreshStrategyDdo;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CloudRefreshStrategyService {
    public static final int REFRESH_NOT_CONFIG = -1;
    public static final int REFRESH_OFF = 0;
    public static final int REFRESH_ON = 1;
    public static final String DEFAULT_STRAIGHTWAY = "default_straightway";
    private static final Logger logger = LoggerFactory.getLogger(CloudRefreshStrategyService.class);
    @Autowired
    private MetaDao metaDao;
    private Map<String, CloudRefreshStrategyDdo> cloudRefreshStrategyMap = Maps.newHashMap();

    @PostConstruct
    public void reload() {
        Set dataSet = this.metaDao.getSetData(false, CloudRefreshStrategyDdo.class, null);
        if (!CollectionUtils.isNullOrEmpty((Collection)dataSet)) {
            dataSet.forEach(e -> this.cloudRefreshStrategyMap.put(e.valueKey(), (CloudRefreshStrategyDdo)((Object)e)));
            logger.info("Load [{}] cloud refresh strategy from database", (Object)this.cloudRefreshStrategyMap.size());
        }
    }

    public CloudRefreshStrategyDdo getCloudRefreshStrategy(String site, String acount) {
        String key = DdoKeyTools.key((Object[])new Object[]{site, acount});
        return this.cloudRefreshStrategyMap.get(key);
    }

    public int getCycleRefreshSwitch(String site, String account) {
        CloudRefreshStrategyDdo strategyDdo = this.getCloudRefreshStrategy(site, account);
        if (strategyDdo == null) {
            return -1;
        }
        if (strategyDdo.getCycleRefresh() == 0) {
            return 0;
        }
        if (strategyDdo.getCycleRefresh() == 1 && strategyDdo.getRefreshInterval() > 0) {
            return 1;
        }
        return 0;
    }

    public int getStraightwayRefreshSwitch(String site, String acount) {
        int status = this.getCycleRefreshSwitch(site, DEFAULT_STRAIGHTWAY);
        if (status == -1) {
            status = 0;
        }
        return status;
    }

    public int getRefreshInterval(String site, String account) {
        CloudRefreshStrategyDdo strategyDdo = this.getCloudRefreshStrategy(site, account);
        if (strategyDdo == null) {
            return 0;
        }
        if (strategyDdo.getCycleRefresh() == 0) {
            return -1;
        }
        return strategyDdo.getRefreshInterval();
    }

    public int getClyleRefreshInterval(String site, String account) {
        return this.getRefreshInterval(site, account);
    }

    public int getStraightwayRefreshLimit(String site, String account) {
        return this.getRefreshInterval(site, DEFAULT_STRAIGHTWAY);
    }

    public ERefreshStatus getRefreshStatus(String site, String account) {
        int status = this.getCycleRefreshSwitch(site, account);
        if (status == 1) {
            return ERefreshStatus.REFRESH_DEFINITE_TIME_ON;
        }
        if (status == 0) {
            return ERefreshStatus.REFRESH_DEFINITE_TIME_OFF;
        }
        status = this.getStraightwayRefreshSwitch(site, account);
        if (status == 1) {
            return ERefreshStatus.REFRESH_REAL_TIME_ON;
        }
        return ERefreshStatus.REFRESH_REAL_TIME_OFF;
    }
}

