package com.valor.vod.meta.model.database.constants;


import com.google.common.base.Strings;

public enum ELanguage {
    EN,
    PT,
    ES;

    public static ELanguage parse(String v) {
        if (Strings.isNullOrEmpty(v)) {
            return null;
        }
        switch (v.toLowerCase().trim()) {
            case "en":
                return EN;
            case "pt":
                return PT;
            case "es":
                return ES;
            default:
                return null;
        }
    }
}
