package com.valor.vod.meta.model.database.constants.playlist;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * playlist列表类型
 *
 * @author Damon.Gao
 * @date 2021/7/27 14:37
 */
public enum EPlaylistListType {
    /**
     * 固定列表
     */
    FIXED_LIST,
    /**
     * 可变列表
     */
    VARIABLE_LIST,
    /**
     * 引用列表
     */
    REF_LIST,
    /**
     * 动作列表
     */
    ACTION_LIST;

    private static final Map<String, EPlaylistListType> VALUE_MAP = Stream.of(values())
        .collect(Collectors.toMap(EPlaylistListType::name, Function.identity()));

    public static EPlaylistListType of(String value) {
        if (value == null) {
            return null;
        }

        return VALUE_MAP.get(value);
    }
}
