package com.valor.vod.meta.model.database.constants.playlist;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * playlist节点类型
 *
 * @author Damon.Gao
 * @date 2021/7/27 15:59
 */
public enum EPlaylistNodeType {
    /**
     * 播放列表
     */
    PLAYLIST,
    /**
     * 视频
     */
    VIDEO,
    /**
     * 人物
     */
    PERSON;

    private static final Map<String, EPlaylistNodeType> VALUE_MAP = Stream.of(values())
        .collect(Collectors.toMap(EPlaylistNodeType::name, Function.identity()));

    public static EPlaylistNodeType of(String value) {
        if (value == null) {
            return null;
        }

        return VALUE_MAP.get(value);
    }
}
