package com.valor.vod.meta.model.database.dao.query.filter.filter;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.valor.vod.meta.model.database.dao.query.filter.FilterField;

import java.util.Set;

import static com.valor.vod.meta.model.database.dao.query.filter.FilterUtil.SQL_AND;
import static com.valor.vod.meta.model.database.dao.query.filter.SqlQueryBuilder.getSqlOperator;

/**
 * Created by Frank.Huang on 2016/8/17.
 */
public class BaseFieldFilter implements IFieldFilter {
    protected String tableName = "";
    protected String fieldName = "";
    protected boolean isCharacter = false;
    protected IFilterValueConverter converter = null;

    public BaseFieldFilter(String tableName, String fieldName, boolean isCharacter, IFilterValueConverter converter) {
        this.tableName = tableName;
        this.fieldName = fieldName;
        this.isCharacter = isCharacter;
        this.converter = converter;
    }

    @Override
    public String getFilter(FilterField field) {
        StringBuilder queryString = new StringBuilder();
        if (field.isRange()) {
            if (queryString.length() > 0) {
                queryString.append(SQL_AND);
            }
            queryString.append(tableName).append(".").append(fieldName);
            queryString.append(getSqlOperator(field.getOperator()));

            queryString.append(" (");

            if (converter == null) {
                queryString.append(Joiner.on(',').skipNulls().join(field.getValues()).toLowerCase().toString());
            } else {
                Set<String> convValues = Sets.newHashSet();
                field.getValues().forEach(e -> {
                    convValues.add(converter.converter(e));
                });

                queryString.append(Joiner.on(',').skipNulls().join(convValues).toLowerCase().toString());
            }

            queryString.append(") ");
        } else {
            field.getValues().forEach(e -> {
                if (queryString.length() > 0) {
                    queryString.append(SQL_AND);
                }

                queryString.append(tableName).append(".").append(fieldName);
                queryString.append(field.getOperator());
                if (isCharacter) {
                    queryString.append('\'');
                }

                if (converter != null) {
                    queryString.append(converter.converter(e));
                } else {
                    queryString.append(e);
                }

                if (isCharacter) {
                    queryString.append('\'');
                }
            });
        }
        return queryString.toString();
    }
}
