package com.valor.vod.meta.model.database.dao.query.filter.filter.converter;

import com.google.common.base.Strings;
import com.valor.vod.meta.model.database.dao.query.filter.filter.IFilterValueConverter;
import com.valor.vod.common.tools.type.DateTimeTools;

/**
 * Created by Frank.Huang on 2016/8/17.
 */
public class LinkedTimeConverter implements IFilterValueConverter {

    @Override
    public String converter(String value) {
        if (Strings.isNullOrEmpty(value)) {
            return "";
        }

        if (value.startsWith("+") || value.startsWith("-")) {
            int diff = Integer.valueOf(value);
            return String.valueOf(DateTimeTools.distanceTodayMS(diff));
        } else {
            return "";
        }
    }
}
