package com.valor.vod.meta.model.database.ddo.base;

import com.google.common.base.Objects;
import com.valor.vod.common.database.model.AbstractLMI;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * Created by Frank.Huang on 2016/5/14.
 */
@Entity
@Table(name = "mfc_country_alias")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class CountryAlias extends AbstractLMI {
    private static final long serialVersionUID = 6384087120450476088L;
    @Id
    @Column(length = 64)
    String alias;

    @Column(length = 64)
    String name;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof CountryAlias)) return false;
        CountryAlias that = (CountryAlias) o;
        return Objects.equal(alias, that.alias) &&
            Objects.equal(name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(alias, name);
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
