package com.valor.vod.meta.model.database.ddo.cloud;

import com.valor.vod.api.model.cloud.ECloudSite;
import com.valor.vod.common.database.model.AbstractLMI;
import com.valor.vod.common.tools.type.DdoKeyTools;

import javax.persistence.*;

/**
 * Created by Frank.Huang on 2016/10/18.
 */
@Entity
@Table(name = "cloud_refresh_strategy")
public class CloudRefreshStrategyDdo extends AbstractLMI {
    private static final long serialVersionUID = -6920341203594478572L;
    /**
     * 为了兼容MM系统,设置自增主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "sid")
    private long sid;

    @Enumerated(value = EnumType.STRING)
    @Column(name = "site", length = 128)
    private ECloudSite site;

    @Column(name = "acct_alias", length = 128)
    private String acctAlias = "";

    @Column(name = "cycle_refresh")
    private int cycleRefresh = 0;

    @Column(name = "refresh_interval")
    private int refreshInterval = 0;

    @Column(name = "realtime_refresh")
    private int realtimeRefresh = 0;

    public ECloudSite getSite() {
        return site;
    }

    public void setSite(ECloudSite site) {
        this.site = site;
    }

    public String getAcctAlias() {
        return acctAlias;
    }

    public void setAcctAlias(String acctAlias) {
        this.acctAlias = acctAlias;
    }

    public int getCycleRefresh() {
        return cycleRefresh;
    }

    public void setCycleRefresh(int cycleRefresh) {
        this.cycleRefresh = cycleRefresh;
    }

    public int getRefreshInterval() {
        return refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public int getRealtimeRefresh() {
        return realtimeRefresh;
    }

    public void setRealtimeRefresh(int realtimeRefresh) {
        this.realtimeRefresh = realtimeRefresh;
    }

    public Long getSid() {
        return sid;
    }

    public void setSid(Long sid) {
        this.sid = sid;
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(site, acctAlias);
    }
}
