package com.valor.vod.meta.model.database.ddo.index;

import com.google.common.base.Objects;
import com.valor.vod.api.model.constant.EVideoType;
import com.valor.vod.common.database.model.AbstractLMI;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NaturalId;

import javax.persistence.*;

/**
 * Created by Frank.Huang on 2016/5/6.
 */
@Entity
@Table(name = "meta_index", indexes = {@Index(name = "ppIdIndex", columnList = "pp_id")})
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class MetaIndex extends AbstractLMI {
    private static final long serialVersionUID = 1621012997411168886L;
    @NaturalId(mutable = true)
    @Column(name = "imdb_id", nullable = false, unique = true, length = 32)
    String imdbId;
    @Transient
    boolean isNew = false;
    @Column(name = "pp_id", unique = true, length = 32)
    String ppId;
    @Id
    @Column(name = "vms_id")
    private Long vmsId;
    @Enumerated(EnumType.ORDINAL)
    @Column(name = "type")
    private EVideoType type;
    @Column(name = "tmdb_id", length = 16)
    private Long tmdbId;
    @Column(name = "status")
    private Integer status;

    public Long getVmsId() {
        return vmsId;
    }

    public void setVmsId(Long vmsId) {
        this.vmsId = vmsId;
    }

    public EVideoType getType() {
        return type;
    }

    public void setType(EVideoType type) {
        this.type = type;
    }

    public String getImdbId() {
        return imdbId;
    }

    public void setImdbId(String imdbId) {
        this.imdbId = imdbId;
    }

    public Long getTmdbId() {
        return tmdbId;
    }

    public void setTmdbId(Long tmdbId) {
        this.tmdbId = tmdbId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public boolean isNew() {
        return isNew;
    }

    public void setNew(boolean aNew) {
        isNew = aNew;
    }

    public String getPpId() {
        return ppId;
    }

    public void setPpId(String ppId) {
        this.ppId = ppId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MetaIndex that = (MetaIndex) o;

        return Objects.equal(this.vmsId, that.vmsId);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(vmsId);
    }
}
