package com.valor.vod.meta.model.database.ddo.media;

import lombok.Data;
import org.hibernate.annotations.SQLInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 *
 * @author Damon.Gao
 * @date 2022/4/8 14:41
 */
@Entity
@Table(name = "episode_info")
@Data
@SQLInsert(sql = "insert into episode_info (episode, meta_id, pp_id, release_date, release_date_int, season, series_id, vms_id) " +
    "values (?, ?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE meta_id=values(meta_id), pp_id=values(pp_id), " +
    "release_date=values(release_date), release_date_int=values(release_date_int)")
public class EpisodeInfo implements Serializable {

    private static final long serialVersionUID = -5651298554742275886L;
    @Id
    @Column(name = "vms_id")
    private Long vmsId;

    @Column(name = "create_time", insertable = false, updatable = false)
    private LocalDateTime createTime;

    @Column(name = "update_time", insertable = false, updatable = false)
    private LocalDateTime updateTime;

    @Column(name = "series_id")
    private Long seriesId;

    @Column(name = "season")
    private int season;

    @Column(name = "episode")
    private int episode;

    @Column(name = "meta_id")
    private String metaId;

    @Column(name = "pp_id")
    private String ppId;

    @Column(name = "release_date")
    private String releaseDate;

    @Column(name = "release_date_int")
    private int releaseDateInt;


}
