package com.valor.vod.meta.model.database.ddo.media;

import com.valor.vod.api.model.common.AbstractPrintable;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name = "media_award_sort")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class MediaAwardSort extends AbstractPrintable {
    private static final long serialVersionUID = 4008885830970074844L;
    @Id
    @Column(name = "award_name", length = 128)
    private String awardName;//奖项名字
    @Id
    @Column(name = "media_type")
    private int mediaType;//类型,0-电影，1-电视
    @Column(name = "weight")
    private int weight;//权重

    public String getAwardName() {
        return awardName;
    }

    public void setAwardName(String awardName) {
        this.awardName = awardName;
    }

    public int getWeight() {
        return weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public int getMediaType() {
        return mediaType;
    }

    public void setMediaType(int mediaType) {
        this.mediaType = mediaType;
    }
}
