package com.valor.vod.meta.model.database.ddo.media;

import com.valor.vod.common.database.model.AbstractLMI;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * Created by Chris.Zeng on 2020/7/20.
 */
@Entity
@Table(name = "vms_meta_relevancy")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class MetaRelevancy extends AbstractLMI {

    private static final long serialVersionUID = 7100517165608054417L;
    @Column(name = "old_pp_id", nullable = false, columnDefinition = "varchar(20) COMMENT '旧pp号'")
    public String oldPpId;
    @Column(name = "new_pp_id", columnDefinition = "varchar(20) COMMENT '新pp号'")
    public String newPpId;
    @Id
    @Column(name = "old_vms_id")
    private Long oldVmsId;
    @Column(name = "new_vms_id")
    private Long newVmsId;

    public Long getOldVmsId() {
        return oldVmsId;
    }

    public void setOldVmsId(Long oldVmsId) {
        this.oldVmsId = oldVmsId;
    }

    public String getOldPpId() {
        return oldPpId;
    }

    public void setOldPpId(String oldPpId) {
        this.oldPpId = oldPpId;
    }

    public Long getNewVmsId() {
        return newVmsId;
    }

    public void setNewVmsId(Long newVmsId) {
        this.newVmsId = newVmsId;
    }

    public String getNewPpId() {
        return newPpId;
    }

    public void setNewPpId(String newPpId) {
        this.newPpId = newPpId;
    }
}
