package com.valor.vod.meta.model.database.ddo.media.base;

import com.google.common.base.Objects;
import com.valor.vod.api.model.constant.EArtworkType;
import com.valor.vod.api.model.constant.EMetaSource;
import com.valor.vod.meta.model.database.ddo.media.tv.TVSeriesArtwork;
import com.valor.vod.common.tools.type.DdoKeyTools;

import javax.persistence.*;

/**
 * Created by Frank.Huang on 2016/4/28.
 */
@MappedSuperclass
public abstract class AbstractArtwork extends AbstractLocaleId {
    private static final long serialVersionUID = -5514075161293245840L;
    @Id
    @Column(name = "path", length = 255)
    public String path;

    @Column(name = "artwork_type")
    @Enumerated(EnumType.STRING)
    protected EArtworkType artworkType = EArtworkType.POSTER;

    @Column(name = "width", columnDefinition = "int default 0")
    protected int width;

    @Column(name = "height", columnDefinition = "int default 0")
    protected int height;

    @Column(name = "flag", length = 255)
    protected String flag;

    @Column(name = "source")
    @Enumerated(EnumType.STRING)
    protected EMetaSource source;

    @Column(name = "source_id")
    protected String sourceId;

    @Column(name = "status", columnDefinition = "int default -1")
    protected int status;

    @Column(name = "url", length = 1024)
    protected String url = "";

    @Column(name = "master", columnDefinition = "int default 0")
    protected int master = 0;

    @Column(name = "adult", columnDefinition = "int default 0")
    protected int adult = 0;

    @Column(name = "image_type", columnDefinition = "int default 0")
    protected int imageType = 0;

    @Id
    @Column(name = "show_seq", columnDefinition = "int default 0")
    protected int showSeq = 0;

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public EArtworkType getArtworkType() {
        return artworkType;
    }

    public void setArtworkType(EArtworkType artworkType) {
        this.artworkType = artworkType;
    }

    public int getWidth() {
        return width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getFlag() {
        return flag;
    }

    public void setFlag(String flag) {
        this.flag = flag;
    }

    public EMetaSource getSource() {
        return source;
    }

    public void setSource(EMetaSource source) {
        this.source = source;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getMaster() {
        return master;
    }

    public void setMaster(int master) {
        this.master = master;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }


    public int getAdult() {
        return adult;
    }

    public void setAdult(int adult) {
        this.adult = adult;
    }

    public int getImageType() {
        return imageType;
    }

    public void setImageType(int imageType) {
        this.imageType = imageType;
    }

    public int getShowSeq() {
        return showSeq;
    }

    public void setShowSeq(int showSeq) {
        this.showSeq = showSeq;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TVSeriesArtwork that = (TVSeriesArtwork) o;

        return Objects.equal(this.path, that.path) &&
            Objects.equal(this.language, that.language) &&
            Objects.equal(this.showSeq, that.showSeq) &&
            Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(path, language, showSeq, id);
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(path, language, showSeq, id);
    }

    @Override
    public boolean valueEquals(Object o) {
        if (!equals(o)) {
            return false;
        } else {
            AbstractArtwork that = (AbstractArtwork) o;

            return Objects.equal(this.artworkType, that.artworkType)
                && Objects.equal(this.width, that.width)
                && Objects.equal(this.height, that.height)
                && Objects.equal(this.url, that.url)
                && Objects.equal(this.source, that.source)
                && Objects.equal(this.sourceId, that.sourceId)
                && Objects.equal(this.master, that.master)
                && Objects.equal(this.adult, that.adult)
                && Objects.equal(this.imageType, that.imageType)
                && Objects.equal(this.showSeq, that.showSeq);

        }
    }
}
