package com.valor.vod.meta.model.database.ddo.media.base;


import com.google.common.base.Objects;
import com.valor.vod.common.tools.type.DdoKeyTools;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/4/28.
 */
@MappedSuperclass
public class AbstractAward extends AbstractId {
    private static final long serialVersionUID = 2949556698662070307L;
    @Id
    @Column(name = "event", length = 128)
    public String event;      // 活动

    @Id
    @Column(name = "category")
    public String category;   // 奖项

    @Id
    @Column(name = "year")
    public int year;          // 年份

    @Id
    @Column(name = "language")
    private String language;

    @Column(name = "source", length = 32)
    private String source;     // 举办地

    @Column(name = "won")
    private int won = 0;       // 是否获奖

    @Column(name = "nominated")
    private int nominated = 0; // 是否提名

    @Column(name = "organized")
    private String organized;      // 组织者

    @Column(name = "personIds", length = 1024)
    private String personIds;      // 获奖人ID列表

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getEvent() {
        return event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public int getYear() {
        return year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getWon() {
        return won;
    }

    public void setWon(int won) {
        this.won = won;
    }

    public int getNominated() {
        return nominated;
    }

    public void setNominated(int nominated) {
        this.nominated = nominated;
    }

    public String getOrganized() {
        return organized;
    }

    public void setOrganized(String organized) {
        this.organized = organized;
    }

    public String getPersonIds() {
        return personIds;
    }

    public void setPersonIds(String personIds) {
        this.personIds = personIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractAward that = (AbstractAward) o;

        return Objects.equal(this.event, that.event) &&
            Objects.equal(this.category, that.category) &&
            Objects.equal(this.id, that.id) &&
            Objects.equal(this.year, that.year) &&
            Objects.equal(this.language, that.language);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(event, category, id, year, language);
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(year, id, event, category, language).toLowerCase();
    }

    @Override
    public boolean valueEquals(Object o) {

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractAward that = (AbstractAward) o;

        return Objects.equal(this.event, that.event)
            && Objects.equal(this.category, that.category)
            && Objects.equal(this.id, that.id)
            && Objects.equal(this.year, that.year)
            && Objects.equal(this.source, that.source)
            && Objects.equal(this.won, that.won)
            && Objects.equal(this.nominated, that.nominated)
            && Objects.equal(this.organized, that.organized)
            && Objects.equal(this.personIds, that.personIds)
            && Objects.equal(this.language, that.language);
    }

}
