package com.valor.vod.meta.model.database.ddo.media.base;

import com.google.common.base.Objects;
import com.valor.vod.common.tools.type.DdoKeyTools;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/4/28.
 */
@MappedSuperclass
public class AbstractLocaleId extends AbstractId {
    private static final long serialVersionUID = -6824832213059900237L;
    @Id
    @Column(name = "language", length = 30)
    public String language;

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(id, language);
    }

    @Override
    public boolean valueEquals(Object o) {
        return equals(o);
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractLocaleId that = (AbstractLocaleId) o;

        return Objects.equal(this.language, that.language) &&
            Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(language, id);
    }
}
