package com.valor.vod.meta.model.database.ddo.media.base;

import com.google.common.base.Objects;
import com.valor.vod.common.tools.type.DdoKeyTools;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/4/28.
 */
@MappedSuperclass
public class AbstractSimilor extends AbstractId {
    private static final long serialVersionUID = -8632432138422048414L;
    @Id
    @Column(name = "similor_id")
    public long similorId;

    @Id
    @Column(name = "pos", columnDefinition = "int default 0")
    protected int pos = 0;

    public long getSimilorId() {
        return similorId;
    }

    public void setSimilorId(long similorId) {
        this.similorId = similorId;
    }

    public int getPos() {
        return pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(id, similorId, pos);
    }

    @Override
    public boolean valueEquals(Object o) {
        return equals(o);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractSimilor that = (AbstractSimilor) o;

        return Objects.equal(this.similorId, that.similorId) &&
            Objects.equal(this.id, that.id) &&
            Objects.equal(this.pos, that.pos);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(similorId, id, pos);
    }
}
