package com.valor.vod.meta.model.database.ddo.media.base;

import com.google.common.base.Objects;
import com.valor.vod.common.tools.type.DdoKeyTools;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/5/14.
 */
@MappedSuperclass
public class AbstractTitleAKA extends AbstractId {
    private static final long serialVersionUID = 1038221532096672202L;
    @Id
    @Column(name = "country", length = 64)
    public String country;

    @Id
    @Column(name = "language", length = 32)
    public String language = "";

    @Id
    @Column(name = "working_title")
    public int workTitle = 0;

    @Column(name = "aka", columnDefinition = "text")
    private String aka;


    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getAka() {
        return aka;
    }

    public void setAka(String aka) {
        this.aka = aka;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public int getWorkTitle() {
        return workTitle;
    }

    public void setWorkTitle(int workTitle) {
        this.workTitle = workTitle;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractTitleAKA that = (AbstractTitleAKA) o;

        return Objects.equal(this.country, that.country) &&
            Objects.equal(this.id, that.id) &&
            Objects.equal(this.language, that.language) &&
            Objects.equal(this.workTitle, that.workTitle);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(country, id, language, workTitle);
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(id, language, country, workTitle);
    }


    @Override
    public boolean valueEquals(Object o) {
        if (!equals(o)) {
            return false;
        } else {
            AbstractTitleAKA that = (AbstractTitleAKA) o;

            return Objects.equal(this.aka, that.aka);
        }
    }
}
