package com.valor.vod.meta.model.database.ddo.media.base;

import com.google.common.base.Objects;
import com.valor.vod.common.tools.type.DdoKeyTools;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/4/29.
 */
@MappedSuperclass
public class AbstractUserReview extends AbstractLocaleId {
    private static final long serialVersionUID = -7868696779901159154L;
    @Id
    @Column(name = "review_key")
    public String reviewKey;

    @Column(name = "source")
    private String source;    //来源

    @Column(name = "user_name")
    private String userName;

    @Column(name = "user_location")
    private String userLocation;

    @Column(name = "review_date")
    private String reviewDate;

    @Lob
    @Column(name = "summary", nullable = false, length = 25000)
    private String summary;

    @Lob
    @Column(name = "content", nullable = false, length = 25000)
    private String content;

    @Column(name = "user_score")
    private Integer userScore = -1;

    @Column(name = "user_score_count")
    private Integer userScoreCount = -1;

    @Column(name = "user_rating")
    private Integer userRating = -1;

    public String getReviewKey() {
        return reviewKey;
    }

    public void setReviewKey(String reviewKey) {
        this.reviewKey = reviewKey;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserLocation() {
        return userLocation;
    }

    public void setUserLocation(String userLocation) {
        this.userLocation = userLocation;
    }

    public String getReviewDate() {
        return reviewDate;
    }

    public void setReviewDate(String reviewDate) {
        this.reviewDate = reviewDate;
    }

    public String getSummary() {
        return summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Integer getUserScore() {
        return userScore;
    }

    public void setUserScore(Integer userScore) {
        this.userScore = userScore;
    }

    public Integer getUserScoreCount() {
        return userScoreCount;
    }

    public void setUserScoreCount(Integer userScoreCount) {
        this.userScoreCount = userScoreCount;
    }

    public Integer getUserRating() {
        return userRating;
    }

    public void setUserRating(Integer userRating) {
        this.userRating = userRating;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractUserReview that = (AbstractUserReview) o;

        return Objects.equal(this.reviewKey, that.reviewKey) &&
            Objects.equal(this.language, that.language) &&
            Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(reviewKey, language, id);
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(id, language, reviewKey);
    }

    @Override
    public boolean valueEquals(Object o) {
        if (!equals(o)) {
            return false;
        } else {
            AbstractUserReview that = (AbstractUserReview) o;

            return Objects.equal(this.reviewDate, that.reviewDate)
                && Objects.equal(this.source, that.source)
                && Objects.equal(this.userName, that.userName)
                && Objects.equal(this.userLocation, that.userLocation)
                && Objects.equal(this.summary, that.summary)
                && Objects.equal(this.content, that.content)
                && Objects.equal(this.userScore, that.userScore)
                && Objects.equal(this.userScoreCount, that.userScoreCount)
                && Objects.equal(this.userRating, that.userRating);
        }
    }
}
