package com.valor.vod.meta.model.database.ddo.media.common;

import com.valor.vod.api.model.constant.EPlaylistStatus;
import com.valor.vod.common.database.model.AbstractLMI;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;

@Entity
@Table(name = "vms_filter_type")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class FilterType extends AbstractLMI {
    private static final long serialVersionUID = 3208989304158553761L;
    @Id
    @Column(name="id")
    private int id;
    @Column(name="name")
    private String name;
    @Column(name="search")
    private String search;
    @Column(name="status")
    @Enumerated(EnumType.ORDINAL)
    private EPlaylistStatus status = EPlaylistStatus.NORMAL;

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSearch() {
        return search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public EPlaylistStatus getStatus() {
        return status;
    }

    public void setStatus(EPlaylistStatus status) {
        this.status = status;
    }
}
