package com.valor.vod.meta.model.database.ddo.media.meter;

import com.google.common.base.Objects;
import com.valor.vod.api.model.constant.EVideoType;
import com.valor.vod.common.database.model.AbstractLMI;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/9/13.
 */
@MappedSuperclass
public class AbstractMeter extends AbstractLMI {
    private static final long serialVersionUID = -605848333256724578L;
    @Id
    @Column(name = "id")
    private Long id;

    @Column(name = "type")
    private EVideoType type;

    @Column(name = "meta_id", length = 32)
    private String metaId;

    @Column(name = "rank")
    private int rank = -1;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public EVideoType getType() {
        return type;
    }

    public void setType(EVideoType type) {
        this.type = type;
    }

    public String getMetaId() {
        return metaId;
    }

    public void setMetaId(String metaId) {
        this.metaId = metaId;
    }

    public int getRank() {
        return rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof AbstractMeter)) return false;
        AbstractMeter that = (AbstractMeter) o;
        return Objects.equal(id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(id);
    }
}
