/*
 *      Copyright (c) 2004-2015 YAMJ Members
 *      https://github.com/organizations/YAMJ/teams
 *
 *      This file is part of the Yet Another Media Jukebox (YAMJ).
 *
 *      YAMJ is free software: you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, either version 3 of the License, or
 *      any later version.
 *
 *      YAMJ is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with YAMJ.  If not, see <http://www.gnu.org/licenses/>.
 *
 *      Web: https://github.com/YAMJ/yamj-v3
 *
 */
package com.valor.vod.meta.model.database.ddo.media.tv;

import com.valor.vod.meta.model.database.ddo.media.base.AbstractMedia;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

//@Entity
//@Table(name = "vms_series", indexes = {@Index(name = "ppIdIndex", columnList = "pp_id")})
//@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
//@SuppressWarnings("unused")
public class Series extends AbstractMedia {
    private static final long serialVersionUID = -709375040815635958L;
    //    @Column(name = "start_year")
    private int startYear = -1;

//    @Column(name = "end_year")
    private int endYear = -1;

//    @Column(name = "season_no")
    private int seasonNo = 0;

//    @Column(name = "episode_no")
    private int episodeNo = 0;

//    @Column(name = "first_air_date", length = 16)
    private String firstAirDate = "";


//    @Column(name = "last_air_date", length = 16)
    private String lastAirDate = "";

    public int getStartYear() {
        return startYear;
    }

    public void setStartYear(int startYear) {
        this.startYear = startYear;
    }

    public int getEndYear() {
        return endYear;
    }

    public void setEndYear(int endYear) {
        this.endYear = endYear;
    }

    public int getSeasonNo() {
        return seasonNo;
    }

    public void setSeasonNo(int seasonNo) {
        this.seasonNo = seasonNo;
    }

    public int getEpisodeNo() {
        return episodeNo;
    }

    public void setEpisodeNo(int episodeNo) {
        this.episodeNo = episodeNo;
    }

    public String getLastAirDate() {
        return lastAirDate;
    }

    public void setLastAirDate(String lastAirDate) {
        this.lastAirDate = lastAirDate;
    }

    public String getFirstAirDate() {
        return firstAirDate;
    }

    public void setFirstAirDate(String firstAirDate) {
        this.firstAirDate = firstAirDate;
    }
}
