/*
 *      Copyright (c) 2004-2015 YAMJ Members
 *      https://github.com/organizations/YAMJ/teams
 *
 *      This file is part of the Yet Another Media Jukebox (YAMJ).
 *
 *      YAMJ is free software: you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, either version 3 of the License, or
 *      any later version.
 *
 *      YAMJ is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with YAMJ.  If not, see <http://www.gnu.org/licenses/>.
 *
 *      Web: https://github.com/YAMJ/yamj-v3
 *
 */
package com.valor.vod.meta.model.database.ddo.media.video;


import com.google.common.base.Objects;
import com.valor.vod.meta.model.database.ddo.media.base.AbstractMedia;
import com.valor.vod.common.tools.type.DdoKeyTools;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

//@Entity
//@Table(name = "vms_video", indexes = {@Index(name = "ppIdIndex", columnList = "pp_id")})
//@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Video extends AbstractMedia {
    private static final long serialVersionUID = -8834455420853563749L;
    //    @Column(name = "series_id")
    private long seriesId = 0;

//    @Column(name = "season_id")
    private long seasonId = 0;

//    @Column(name = "season", columnDefinition = "int default -1")
    private int season = -1;

//    @Column(name = "episode", columnDefinition = "int default -1")
    private int episode = -1;

    public long getSeasonId() {
        return seasonId;
    }

    public void setSeasonId(long seasonId) {
        this.seasonId = seasonId;
    }

    public int getSeason() {
        return season;
    }

    public void setSeason(int season) {
        this.season = season;
    }

    public int getEpisode() {
        return episode;
    }

    public void setEpisode(int episode) {
        this.episode = episode;
    }

    public long getSeriesId() {
        return seriesId;
    }

    public void setSeriesId(long seriesId) {
        this.seriesId = seriesId;
    }


    @Override
    public boolean valueEquals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Video that = (Video) o;

        return Objects.equal(this.seriesId, that.seriesId) &&
            Objects.equal(this.seasonId, that.seasonId) &&
            Objects.equal(this.season, that.season) &&
            Objects.equal(this.episode, that.episode) &&
            Objects.equal(this.type, that.type) &&
            Objects.equal(this.publicationYear, that.publicationYear) &&
            Objects.equal(this.releaseDate, that.releaseDate) &&
            Objects.equal(this.runtime, that.runtime) &&
            Objects.equal(this.popularity, that.popularity) &&
            Objects.equal(this.adult, that.adult) &&
            Objects.equal(this.originalTitle, that.originalTitle) &&
            Objects.equal(this.originalLanguage, that.originalLanguage) &&
            Objects.equal(this.originalCountry, that.originalCountry) &&
            Objects.equal(this.displayId, that.displayId) &&
            Objects.equal(this.imdbId, that.imdbId) &&
            Objects.equal(this.ppId, that.ppId) &&
            Objects.equal(this.tmdbId, that.tmdbId) &&
            Objects.equal(this.rating, that.rating) &&
            Objects.equal(this.voteCount, that.voteCount) &&
            Objects.equal(this.status, that.status) &&
            Objects.equal(this.complete, that.complete) &&
            Objects.equal(this.manual, that.manual) &&
            Objects.equal(this.WR, that.WR) &&
            Objects.equal(this.id, that.id);
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(seriesId, 0L, id);
    }
}
