package com.valor.vod.meta.model.database.ddo.media.video;

import com.google.common.base.Objects;
import com.valor.vod.meta.model.database.ddo.media.base.AbstractCountry;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * Created by Frank.Huang on 2016/4/28.
 */
//@Entity
//@Table(name = "vms_video_country")
//@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class VideoCountry extends AbstractCountry {

    private static final long serialVersionUID = -2294807492629752970L;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        VideoCountry that = (VideoCountry) o;

        return Objects.equal(this.dataId, that.dataId) &&
            Objects.equal(this.id, that.id) &&
            Objects.equal(this.countrySeq, that.countrySeq);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(dataId, id, countrySeq);
    }
}
