package com.valor.vod.meta.model.database.ddo.openapi;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;

@Data
@Entity
@Table(name = "meta_open_config")
public class MetaOpenConfigDDO implements Serializable {
    private static final long serialVersionUID = 817532033428823176L;
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id", updatable = false, nullable = false)
    private Long id;

    @Column(name = "playlist_id")
    private Long playlistId;

    @Column(name = "open_id")
    private Long openId;

    @Column(name = "name")
    private String name;

    @Column(name = "remark")
    private String remark;

    @Column(name = "update_user")
    private Long updateUser;

    @Column(name = "update_time", insertable = false, updatable = false)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MetaOpenConfigDDO that = (MetaOpenConfigDDO) o;
        return Objects.equals(playlistId, that.playlistId) &&
                Objects.equals(openId, that.openId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(playlistId, openId);
    }

}
