package com.valor.vod.meta.model.database.ddo.person;

import com.google.common.base.Objects;
import com.valor.vod.meta.model.database.ddo.media.base.AbstractId;
import com.valor.vod.common.tools.type.DdoKeyTools;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/8/13.
 */
@MappedSuperclass
public class AbstractPersonAward extends AbstractId {
    private static final long serialVersionUID = 3139219301693451781L;
    @Id
    @Column(name = "event", length = 128)
    public String event;      // 活动

    @Id
    @Column(name = "category")
    public String category;   // 奖项

    @Id
    @Column(name = "year")
    public int year;          // 年份

    @Id
    @Column(name = "language")
    private String language;

    @Column(name = "source", length = 32)
    protected String source;     // 举办地

    @Column(name = "won")
    protected int won = 0;       // 是否获奖

    @Column(name = "nominated")
    protected int nominated = 0; // 是否提名

    @Column(name = "organized")
    protected String organized;      // 组织者

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getEvent() {
        return event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public int getYear() {
        return year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public int getWon() {
        return won;
    }

    public void setWon(int won) {
        this.won = won;
    }

    public int getNominated() {
        return nominated;
    }

    public void setNominated(int nominated) {
        this.nominated = nominated;
    }

    public String getOrganized() {
        return organized;
    }

    public void setOrganized(String organized) {
        this.organized = organized;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractPersonAward that = (AbstractPersonAward) o;

        return Objects.equal(this.event, that.event) &&
            Objects.equal(this.category, that.category) &&
            Objects.equal(this.year, that.year) &&
            Objects.equal(this.id, that.id) &&
            Objects.equal(this.language, that.language);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(event, category, year, id, language);
    }


    @Override
    public String valueKey() {
        return DdoKeyTools.key(id, event, category);
    }

    @Override
    public boolean valueEquals(Object o) {
        if (!equals(o)) {
            return false;
        } else {
            AbstractPersonAward that = (AbstractPersonAward) o;

            return Objects.equal(this.source, that.source)
                && Objects.equal(this.won, that.won)
                && Objects.equal(this.nominated, that.nominated)
                && Objects.equal(this.organized, that.organized);
        }
    }

}
