package com.valor.vod.meta.model.database.ddo.playlist;

import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

@Getter
@Setter
@Entity
@Table(name = "playlist_localization")
public class LocalizationDDO implements Serializable {
    private static final long serialVersionUID = -5144407489869895175L;
    @Id
    @Column(name = "id")
    private Long id = 0L;

    @Column(name = "name", columnDefinition = "int default 0")
    private String name;

    @Column(name = "remarks")
    private String remarks;

    @Column(name = "type", length = 50)
    private String type;

    @Column(name = "region", length = 64)
    private String region;

    @Column(name = "local_content", length = 512)
    private String localContent;

    @Column(name = "create_user", columnDefinition = "int default 0")
    protected int creatUser = 0;

    @Column(name = "create_time", insertable = false, updatable = false)
    protected LocalDateTime createTime;

    @Column(name = "update_user", columnDefinition = "int default 0")
    protected int updateUser = 0;

    @Column(name = "update_time", insertable = false, updatable = false)
    protected LocalDateTime updateTime;

}
